-- PyrosparkCore - Server Commands
-- Server-side command handling

-- Command definitions for help system
local commands = {
    {command = '/ps dv', description = 'Delete nearest vehicle', permission = 'pyrosparkcore.ps.dv'},
    {command = '/ps seatdrive', description = 'Move to driver seat', permission = 'pyrosparkcore.ps.seatdrive'},
    {command = '/ps fix', description = 'Repair current vehicle', permission = 'pyrosparkcore.ps.fix'},
    {command = '/ps refuel', description = 'Refuel current vehicle', permission = 'pyrosparkcore.ps.refuel'},
    {command = '/ps coords', description = 'Get coordinates', permission = 'pyrosparkcore.ps.coords'},
    {command = '/ps whoami', description = 'Show player info', permission = 'pyrosparkcore.ps.whoami'},
}

-- ============================================================================
--                          HELP SYSTEM
-- ============================================================================

RegisterNetEvent('ps:requestHelp', function()
    local source = source
    local availableCommands = {}

    -- Check which commands the player has permission for
    for _, cmd in ipairs(commands) do
        if IsPlayerAceAllowed(source, cmd.permission) then
            table.insert(availableCommands, {
                command = cmd.command,
                description = cmd.description
            })
        end
    end

    -- Always show help command
    table.insert(availableCommands, 1, {
        command = '/ps help',
        description = 'Show this help menu'
    })

    TriggerClientEvent('ps:showHelp', source, availableCommands)
end)

-- ============================================================================
--                          UTILITY COMMANDS
-- ============================================================================

-- ps whoami - Show Player Info
RegisterNetEvent('ps:whoami', function()
    local source = source

    if source == 0 then
        print('[PyrosparkCore] This command cannot be used from console')
        return
    end

    -- Check permission
    if not IsPlayerAceAllowed(source, 'pyrosparkcore.ps.whoami') then
        TriggerClientEvent('chat:addMessage', source, {
            color = {255, 0, 0},
            args = {'^3[PyrosparkCore]^7', 'You don\'t have permission to use this command'}
        })
        return
    end

    local playerName = GetPlayerName(source)
    local identifiers = GetPlayerIdentifiers(source)
    local steamId = 'Not found'
    local license = 'Not found'
    local discord = 'Not found'

    -- Parse identifiers
    for _, identifier in ipairs(identifiers) do
        if string.match(identifier, 'steam:') then
            steamId = identifier
        elseif string.match(identifier, 'license:') then
            license = identifier
        elseif string.match(identifier, 'discord:') then
            discord = identifier
        end
    end

    -- Send info to player
    TriggerClientEvent('chat:addMessage', source, {
        color = {0, 255, 0},
        multiline = true,
        args = {'^3[PyrosparkCore]^7', '=== YOUR INFO ==='}
    })
    TriggerClientEvent('chat:addMessage', source, {
        args = {'', 'Server ID: ' .. source}
    })
    TriggerClientEvent('chat:addMessage', source, {
        args = {'', 'Name: ' .. playerName}
    })
    TriggerClientEvent('chat:addMessage', source, {
        args = {'', 'Steam: ' .. steamId}
    })
    TriggerClientEvent('chat:addMessage', source, {
        args = {'', 'License: ' .. license}
    })
    TriggerClientEvent('chat:addMessage', source, {
        args = {'', 'Discord: ' .. discord}
    })

    if Config.DebugMode then
        print(string.format('[PyrosparkCore] Player %d (%s) used /ps whoami', source, playerName))
    end
end)
